﻿using System;
using System.Diagnostics;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class SendLoginRequestToEcStep : FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            if (!string.IsNullOrEmpty(state.PatUserDuz) && !string.IsNullOrEmpty(state.ProUserDuz))
                return;
            try
            {
                if (!string.IsNullOrEmpty(state.ConsultsFakeResponseType))
                {
                    if (state.ProEcRequest != null)
                    {
                        state.ProUserDuz = "FAKE_ProviderLogin";
                        state.ProEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqproviderInfo.mcs_userId = state.ProUserDuz;
                    }
                    if (state.PatEcRequest != null)
                    {
                        state.PatUserDuz = "FAKE_PatientLogin";
                        state.PatEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqproviderInfo.mcs_userId = state.PatUserDuz;
                    }
                    return;
                }
                LoginRequest patLogin = new LoginRequest
                {
                    side = Side.Patient,
                    Request = state.PatLoginRequest
                };
                LoginRequest proLogin = new LoginRequest
                {
                    side = Side.Provider,
                    Request = state.ProLoginRequest
                };

                var timer = new Stopwatch();
                timer.Start();
                Parallel.ForEach(new LoginRequest[] { patLogin, proLogin }, login =>
                {
                    if (state.ProEcRequest == null && login.side == Side.Provider || state.PatEcRequest == null && login.side == Side.Patient)
                        Logger.Instance.Debug(string.Format("Skipping {0} side login of Home/Mobile ({1}) or SFT ({2}) appt.", login.side.ToString(), state.IsHomeMobile, state.IsStoreForward));
                    else if (login.side == Side.Provider && string.IsNullOrEmpty(state.ProUserDuz))
                        login.userId = VistaMapperHelper.GetViaLoginId(login.Request, login.side);
                    else if (login.side == Side.Patient && string.IsNullOrEmpty(state.PatUserDuz))
                        login.userId = VistaMapperHelper.GetViaLoginId(login.Request, login.side);
                });
                timer.Stop();
                state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
                if (!string.IsNullOrEmpty(patLogin.userId))
                {
                    state.PatEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqproviderInfo.mcs_userId = patLogin.userId;
                    state.PatUserDuz = patLogin.userId;
                }
                if (!string.IsNullOrEmpty(proLogin.userId))
                {
                    state.ProEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqproviderInfo.mcs_userId = proLogin.userId;
                    state.ProUserDuz = proLogin.userId;
                }
            }
            catch(Exception ex)
            {
                Logger.Instance.Error("Error in Login EC call: " + ex.Message);
                throw;
            }
        }
    }
    
}
